const
	ScriptVersion = "2025.5",
	ReleaseDate = "November2025"
  
messages

@msgHotKeyHelp
This help dialog contains a short list of useful hotkeys for using Band-in-a-Box with the JAWS scripts.

Hit JAWSKey+F1 twice quickly to bring up a web page containing a more comprehensive list of hotkeys grouped by topic under separate headings.

IMPORTANT: To bring up a separate dialog that contains required settings and hints for using JAWS with Band-In-A-Box, hit
%KeyFor(JAWSKeyF1)
Note: These scripts will not work properly without making these changes!
The documentation also contains a link to a PG Music site that describes a number of new accessibility enhancements along with hotkeys and suggestions introduced in version 2023 of Band-in-a-Box.

Here is the short list of useful hotkeys:

Speak the highlighted chord phonetically: JAWSKey+Shift+C
Bring up a list of highlighted chords from which you can bring up the context menu for the chords:
	Press JAWSKey+Shift+C twice quickly

Speak the current Bar, Beat, and Part: JAWSKey+Shift+R 

Read the style memo for the song or selected Style: JAWSKey+Shift+E
Put the style memo information in the Virtual Viewer: Press JAWSKey+Shift+E twice quickly

Vary the amount of information spoken during playback by hitting JAWSKey+Shift+S and cycling among the settings:
  1.  Speak chords, measures, and embellishments
  2.  Speak chords and measures only
  3.  Speak chords only
  4.  Do not speak anything
The desired setting is saved in the JCF file for the next session.

Speak the last pop-up hint: JAWSKey+Shift+T
Toggle the automatic speaking of pop-up hints on and off: press JAWSKey+T twice quickly
The desired setting is saved in the JCF file for the next session.

The Preferences (Control+E) / Channels dialog can be used to set the mixer and other parameters for each instrument.  When in this dialog:
	Move from parameter to parameter for a given insturment by using Tab and Shift+Tab
	Switch from instrument to instrument by using Control+Up/Down Arrow
	Move between other options in this dialog and the instrument parameters quickly by hitting Control+Tab and Control+Shift+Tab

Other useful keystrokes for selecting and modifying instruements can be found in the Band-In-A-Box Help documentation under the "References" book and the 3 topics on Keystroke Hotkeys.

JAWS will provide speech feedback for the following actions supported by native BIAB hotkeys:
	Hit Control+2-9 to select and instrument and then click the right mouse button to bring up the context menu for that instrument.
	Hit Alt+2-9 to toggle the Mute / Unmute status for a particular instrument
	Hit Shift+Control + letter to control many mixing parameters (see BIAB Help documentation)
	Hit Control+alt + number keys to transpose various parts (see BIAB Help documentation)
	
Below are some useful keystrokes that can be used in the Style Picker dialog (Control+F9):
	Alt+S = move to next style and speak memo.
	Shift+Alt+S = move to previous style and speak memo.
	Space = play audio sample for the selected style.
	Control+Space = play audio sample of selected style based on chords.
	Alt+T = Stop playback of sample based on chords.
	Shift+Control+M = bring up the list of available filters for the style.
	Shift+Control+1 = open the Category menu for the style.
	Shift+Control+2 = open the Time Signature menu for the style.
	Shift+Control+3 = open the Feel menu for the style.
	Shift+Control+4 = open the Tempo menu for the style.
	Shift+Control+5 = open the Type menu for the style.
	Shift+Control+6 = open the Other menu for the style.
			
(Hit Escape to close this message)
@@
@msgBIABHints
Here are some suggested settings and hints for using JAWS with Band-In-A-Box.
These scripts were optimized for Band-in-a-Box 2017.  

In order to Make Band-In-a-Box work properly with JAWS certain changes need to be made to the Preferences / Display settings.  There are two methods for doing this:

Method #1: Loading the pre-configured scheme.
1.  Find the file entitled "bbw JAWS access scheme.csc" that came with these scripts and copy it to the "data" folder under your BIAB installation.  This should be something like:
  c:\bb\data
2.  In the Band-In-a-Box program, open up the Display preferences by hitting control+E and hitting enter on the "display" button.
3.  Tab to "Load Scheme" and hit enter.
4.  Arrow down to "bbw JAWS access scheme" to select this scheme and hit enter.
5.  Shift+Tab to "OK" and hit enter to close the Display Preferences dialog.
6.  Your preferences should now be set to use JAWS with Band-In-a-Box and you can ignore Method #2 below!

Method #2: Manual method (instead of using Method #1)
1.  Hit control+E and hit "Enter" on Display to get into the dialog.
2.  Tab 10 times to get to the checkbox labled "Highlight Selected Cell.  Make sure this box is checked.
3.  Tab 14 more times until you come to to "Font..." and hit enter.
4.  Arrow down to "Times New roman" to select this font.
5.  Tab to "OK" and hit enter.
6.  Tab to the Combo Box entitled "Superscript Chord Extensions (Main)" and make sure "Never" is selected.
7.  Tab to the next Combo Box entitled "Superscript Chord Extensions (Additional)" and make sure "Never" is selected.
8.  Tab to the check box entitled "Autoadjust Number of Rows" and make sure it is checked.
9.  Next, turn on the JAWS cursor and navigate to a line where you hear the text "Min rows Max rows".  Below this line you will see two numbers.  These are the minimum and maximun number of lines to show in the Chord Sheet display.
  Use the JAWS cursor to navigate to one of these at a time and route the PC cursor to the JAWS cursor.  Change the min and max numbers to 2 and 3, respectively.
10.  Finally, with the PC cursor active, tab to "OK" and hit enter to make the changes to the Display preferences.

If chords or other information do not appear to be reading properly, hit Control+W to make sure you are in the Chord window.  Sometimes refreshing the screen with JAWSKey+Escape or Alt+Tabbing to another application and back again can fix these issues.

Also, make sure that all extraneous windows (such as "Big Lyrics", "Big Piano", etc.) have been closed.  You can check the status of these windows by going to the Windows pull-down menu by hitting Alt+D.

If the Control+T BIAB hotkey is used to move the Chord window to the top of the screen, some screen information will be obscured and JAWS will not be able to read it.  For example, if one tries to read the song memo information with JAWSKey+Shift+E, the user will hear information that is not related to the style memo.

JAWS verbosity should be set to Intermediate or Beginner to insure proper speech feedback from all dialogs and events.

BIAB supports a number of native hotkeys and commands to control many functions and settings.  Most of these can be found in the BIAB Help documentation by hitting F1 and looking for the 3 topics on Keyboard Hotkeys contained in the "References" book.  The JAWS Keyboard Help (JAWSKey+1) can also be used to identify the function of most of these hotkeys as well as other scripting functions.

Hit JAWSKey+F1 once to bring up a list of other useful hotkeys supported by these scripts.

(Hit Escape to close this message)
@@
@msgSwitchToDefaultConfig
switching to JAWS default configuration
@@
@msgScriptInfo
The Band-In-A-Box scripts are running
The application name is %1
This is version %2 of the scripts
Release date: %3
@@
@msgBass
Bass
@@
@msgDrums
Drums
@@
@msgPiano
Piano
@@
@msgGuitar
Guitar
@@
@msgStrings
Strings
@@
@msgMuted
muted
@@
@msgUnmuted
unmuted
@@
@msgSelected
selected
@@
@msgUnselected
unselected
@@
@msgDecreaseVolume
decrease part's volume
@@
@msgIncreaseVolume
increase part's volume
@@
@msgDecreasePan
decrease part's panning
@@
@msgIncreasePan
increase part's panning
@@
@msgDecreaseMidiReverb
decrease midi reverb
@@
@msgIncreaseMidiReverb
increase midi reverb
@@
@msgDecreaseAudioReverb
decrease audio reverb
@@
@msgIncreaseAudioReverb
increase audio reverb
@@	
@msgDecreaseBank0
decrease bank 0
@@
@msgIncreaseBank0
increase bank 0
@@
@msgSelectingPatch
selecting patch number
@@
@msgDecreasePatchNumber
decrease patch number
@@
@msgIncreasePatchNumber
increase patch number
@@
@msgDecreaseMasterVolume
decrease master volume by 5
@@
@msgIncreaseMasterVolume
increase master volume by 5
@@
@msgSetMasterVolume
set master volume
@@
@msgReduceAllPartVolumes
reduce all part volumes by 5
@@
@msgIncreaseAllPartVolumes
increase all part volumes by 5
@@
@msgSetAllPartVolumes
set all part volumes 
@@
@msgSetCurrentPartsVolume
set current part's volume
@@
@msgTransposeMelodyDown1
transpose melody down 1 octave
@@
@msgTransposeMelodyUp1
transpose melody up 1 octave
@@
@msgTransposeSoloistDown1
transpose soloist down 1 octave
@@
@msgTransposeSoloistUp1
transpose soloist up 1 octive
@@
@msgTransposeDown1
transpose down 1 semitone
@@
@msgTransposeUp1
transpose up 1 semitone
@@
@msgTransposeSettingDialog
transpose setting dialog
@@
@msgPush8
with a one eight push
@@
@msgPush16
with a one sixteenth push
@@
@msgSus
suspended
@@
@msgFlat
flat
@@
@msgSharp
sharp
@@
@msgMajor
major
@@
@msgMinor
minor
@@
@msgAugmented
augmented
@@
@msgDiminished
diminished
@@
@msgOver
over
@@
@msgBassNote
bass
@@
@msgRest
 rest
@@
@msgShot
 shot
@@
@msgHeld
 held
@@
@msgExceptFor
except for
@@
@msgBar
bar
@@
@msgBeat
beat
@@
@msgPart
part
@@
@msgPartChanged
part changed to
@@
@msgNotationWindow
The notation window is visible.  For best results, hit control+w to switch to the Chord window.
@@
@msgChordWindow
The Chord window is visible
@@
@msgSongTitle
the title of the song is:
@@
@msgRightClick
click the right mouse button to bring up more options
@@
@msgNotVisible
not visible
@@
@msgHitEscape
Hit Escape to exit this dialog
@@
@msgActivatePCCursor
Activate the PC cursor to exit
@@
@msgSpeakWhilePlaying0
Speaking of chords, measures, and other embellishments during playback is turned on
@@
@msgSpeakWhilePlaying1
Speaking of chords and measures during playback is turned on
@@
@msgSpeakWhilePlaying2
Speaking of chords only during playback is turned on
@@
@msgSpeakWhilePlaying3
Speaking during playback is turned off
@@
@msgSpeakHintsOn
Automatic speaking of pop-up hints is turned on
@@
@msgSpeakHintsOff
Automatic speaking of pop-up hints is turned off
@@
@msgUseControlTab
Use Control+Tab and Shift+Control+Tab to move quikckly between the button options and instrument parameters in this dialog
@@
@msgAtEndOfInstrumentsList
At end of instruments list
@@
@msgDescription
Description:
@@
@msgNoHintAvailable
No Hint Available
@@
@msgStylePickerNotVisible
The Style Picker is not visible
@@
@msgFilterOptions
Filter Options
@@
@msgUnableToFindFilterOptions
Unable to find Filter Options in Style Picker.  Make sure the Style Picker is open.
@@
EndMessages
